
use builtin;
use str;

set edit:completion:arg-completer[tree-sitter] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'tree-sitter'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'tree-sitter'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand init-config 'Generate a default config file'
            cand init 'Initialize a grammar repository'
            cand generate 'Generate a parser'
            cand build 'Compile a parser'
            cand parse 'Parse files'
            cand test 'Run a parser''s tests'
            cand version 'Display or increment the version of a grammar'
            cand fuzz 'Fuzz a parser'
            cand query 'Search files using a syntax tree query'
            cand highlight 'Highlight a file'
            cand tags 'Generate a list of tags'
            cand playground 'Start local playground for a parser in the browser'
            cand dump-languages 'Print info about all known language parsers'
            cand complete 'Generate shell completions'
        }
        &'tree-sitter;init-config'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;init'= {
            cand -p 'The path to the tree-sitter grammar directory'
            cand --grammar-path 'The path to the tree-sitter grammar directory'
            cand -u 'Update outdated files'
            cand --update 'Update outdated files'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;generate'= {
            cand --abi 'Select the language ABI version to generate (default 15). Use --abi=latest to generate the newest supported version (15).'
            cand --libdir 'Deprecated: use the `build` command'
            cand -o 'The path to output the generated source files'
            cand --output 'The path to output the generated source files'
            cand --report-states-for-rule 'Produce a report of the states for the given rule, use `-` to report every rule'
            cand --js-runtime 'The name or path of the JavaScript runtime to use for generating parsers, specify `native` to use the native `QuickJS` runtime'
            cand -l 'Show debug log during generation'
            cand --log 'Show debug log during generation'
            cand --no-parser 'Only generate `grammar.json` and `node-types.json`'
            cand -b 'Deprecated: use the `build` command'
            cand --build 'Deprecated: use the `build` command'
            cand -0 'Deprecated: use the `build` command'
            cand --debug-build 'Deprecated: use the `build` command'
            cand --json 'Deprecated: use --json-summary'
            cand --json-summary 'Report conflicts in a JSON format'
            cand --disable-optimizations 'Disable optimizations when generating the parser. Currently, this only affects the merging of compatible parse states'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;build'= {
            cand -o 'The path to output the compiled file'
            cand --output 'The path to output the compiled file'
            cand -w 'Build a Wasm module instead of a dynamic library'
            cand --wasm 'Build a Wasm module instead of a dynamic library'
            cand --reuse-allocator 'Make the parser reuse the same allocator as the library'
            cand -0 'Compile a parser in debug mode'
            cand --debug 'Compile a parser in debug mode'
            cand -v 'Display verbose build information'
            cand --verbose 'Display verbose build information'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;parse'= {
            cand --paths 'The path to a file with paths to source file(s)'
            cand -p 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand --grammar-path 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand -l 'The path to the parser''s dynamic library'
            cand --lib-path 'The path to the parser''s dynamic library'
            cand --lang-name 'If `--lib-path` is used, the name of the language used to extract the library''s language function'
            cand --scope 'Select a language by the scope instead of a file extension'
            cand -d 'Show parsing debug log'
            cand --debug 'Show parsing debug log'
            cand --timeout 'Interrupt the parsing process by timeout (µs)'
            cand --edits 'Apply edits in the format: \"row,col|position delcount insert_text\", can be supplied multiple times'
            cand --encoding 'The encoding of the input files'
            cand --config-path 'The path to an alternative config.json file'
            cand -n 'Parse the contents of a specific test'
            cand --test-number 'Parse the contents of a specific test'
            cand -0 'Compile a parser in debug mode'
            cand --debug-build 'Compile a parser in debug mode'
            cand -D 'Produce the log.html file with debug graphs'
            cand --debug-graph 'Produce the log.html file with debug graphs'
            cand --wasm 'Compile parsers to Wasm instead of native dynamic libraries'
            cand --dot 'Output the parse data with graphviz dot'
            cand -x 'Output the parse data in XML format'
            cand --xml 'Output the parse data in XML format'
            cand -c 'Output the parse data in a pretty-printed CST format'
            cand --cst 'Output the parse data in a pretty-printed CST format'
            cand -s 'Show parsing statistic'
            cand --stat 'Show parsing statistic'
            cand -t 'Measure execution time'
            cand --time 'Measure execution time'
            cand -q 'Suppress main output'
            cand --quiet 'Suppress main output'
            cand --open-log 'Open `log.html` in the default browser, if `--debug-graph` is supplied'
            cand --json 'Deprecated: use --json-summary'
            cand -j 'Output parsing results in a JSON format'
            cand --json-summary 'Output parsing results in a JSON format'
            cand -r 'Force rebuild the parser'
            cand --rebuild 'Force rebuild the parser'
            cand --no-ranges 'Omit ranges in the output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;test'= {
            cand -i 'Only run corpus test cases whose name matches the given regex'
            cand --include 'Only run corpus test cases whose name matches the given regex'
            cand -e 'Only run corpus test cases whose name does not match the given regex'
            cand --exclude 'Only run corpus test cases whose name does not match the given regex'
            cand --file-name 'Only run corpus test cases from a given filename'
            cand -p 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand --grammar-path 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand -l 'The path to the parser''s dynamic library'
            cand --lib-path 'The path to the parser''s dynamic library'
            cand --lang-name 'If `--lib-path` is used, the name of the language used to extract the library''s language function'
            cand --config-path 'The path to an alternative config.json file'
            cand --stat 'Show parsing statistics'
            cand -u 'Update all syntax trees in corpus files with current parser output'
            cand --update 'Update all syntax trees in corpus files with current parser output'
            cand -d 'Show parsing debug log'
            cand --debug 'Show parsing debug log'
            cand -0 'Compile a parser in debug mode'
            cand --debug-build 'Compile a parser in debug mode'
            cand -D 'Produce the log.html file with debug graphs'
            cand --debug-graph 'Produce the log.html file with debug graphs'
            cand --wasm 'Compile parsers to Wasm instead of native dynamic libraries'
            cand --open-log 'Open `log.html` in the default browser, if `--debug-graph` is supplied'
            cand --show-fields 'Force showing fields in test diffs'
            cand -r 'Force rebuild the parser'
            cand --rebuild 'Force rebuild the parser'
            cand --overview-only 'Show only the pass-fail overview tree'
            cand --json-summary 'Output the test summary in a JSON format'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;version'= {
            cand -p 'The path to the tree-sitter grammar directory'
            cand --grammar-path 'The path to the tree-sitter grammar directory'
            cand --bump 'Automatically bump from the current version'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tree-sitter;fuzz'= {
            cand -s 'List of test names to skip'
            cand --skip 'List of test names to skip'
            cand --subdir 'Subdirectory to the language'
            cand -p 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand --grammar-path 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand --lib-path 'The path to the parser''s dynamic library'
            cand --lang-name 'If `--lib-path` is used, the name of the language used to extract the library''s language function'
            cand --edits 'Maximum number of edits to perform per fuzz test (Default: 3)'
            cand --iterations 'Number of fuzzing iterations to run per test (Default: 10)'
            cand -i 'Only fuzz corpus test cases whose name matches the given regex'
            cand --include 'Only fuzz corpus test cases whose name matches the given regex'
            cand -e 'Only fuzz corpus test cases whose name does not match the given regex'
            cand --exclude 'Only fuzz corpus test cases whose name does not match the given regex'
            cand --log-graphs 'Enable logging of graphs and input'
            cand -l 'Enable parser logging'
            cand --log 'Enable parser logging'
            cand -r 'Force rebuild the parser'
            cand --rebuild 'Force rebuild the parser'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;query'= {
            cand -p 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand --grammar-path 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand -l 'The path to the parser''s dynamic library'
            cand --lib-path 'The path to the parser''s dynamic library'
            cand --lang-name 'If `--lib-path` is used, the name of the language used to extract the library''s language function'
            cand --paths 'The path to a file with paths to source file(s)'
            cand --byte-range 'The range of byte offsets in which the query will be executed'
            cand --row-range 'The range of rows in which the query will be executed'
            cand --containing-byte-range 'The range of byte offsets in which the query will be executed. Only the matches that are fully contained within the provided byte range will be returned'
            cand --containing-row-range 'The range of rows in which the query will be executed. Only the matches that are fully contained within the provided row range will be returned'
            cand --scope 'Select a language by the scope instead of a file extension'
            cand --config-path 'The path to an alternative config.json file'
            cand -n 'Query the contents of a specific test'
            cand --test-number 'Query the contents of a specific test'
            cand -t 'Measure execution time'
            cand --time 'Measure execution time'
            cand -q 'Suppress main output'
            cand --quiet 'Suppress main output'
            cand -c 'Order by captures instead of matches'
            cand --captures 'Order by captures instead of matches'
            cand --test 'Whether to run query tests or not'
            cand -r 'Force rebuild the parser'
            cand --rebuild 'Force rebuild the parser'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;highlight'= {
            cand --captures-path 'The path to a file with captures'
            cand --query-paths 'The paths to files with queries'
            cand --scope 'Select a language by the scope instead of a file extension'
            cand --paths 'The path to a file with paths to source file(s)'
            cand -p 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand --grammar-path 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand --config-path 'The path to an alternative config.json file'
            cand -n 'Highlight the contents of a specific test'
            cand --test-number 'Highlight the contents of a specific test'
            cand --encoding 'The encoding of the input files'
            cand -H 'Generate highlighting as an HTML document'
            cand --html 'Generate highlighting as an HTML document'
            cand --css-classes 'When generating HTML, use css classes rather than inline styles'
            cand --check 'Check that highlighting captures conform strictly to standards'
            cand -t 'Measure execution time'
            cand --time 'Measure execution time'
            cand -q 'Suppress main output'
            cand --quiet 'Suppress main output'
            cand -r 'Force rebuild the parser'
            cand --rebuild 'Force rebuild the parser'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;tags'= {
            cand --scope 'Select a language by the scope instead of a file extension'
            cand --paths 'The path to a file with paths to source file(s)'
            cand -p 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand --grammar-path 'The path to the tree-sitter grammar directory, implies --rebuild'
            cand --config-path 'The path to an alternative config.json file'
            cand -n 'Generate tags from the contents of a specific test'
            cand --test-number 'Generate tags from the contents of a specific test'
            cand -t 'Measure execution time'
            cand --time 'Measure execution time'
            cand -q 'Suppress main output'
            cand --quiet 'Suppress main output'
            cand -r 'Force rebuild the parser'
            cand --rebuild 'Force rebuild the parser'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;playground'= {
            cand --grammar-path 'Path to the directory containing the grammar and Wasm files'
            cand -e 'Export playground files to specified directory instead of serving them'
            cand --export 'Export playground files to specified directory instead of serving them'
            cand -q 'Don''t open in default browser'
            cand --quiet 'Don''t open in default browser'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;dump-languages'= {
            cand --config-path 'The path to an alternative config.json file'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;complete'= {
            cand -s 'The shell to generate completions for'
            cand --shell 'The shell to generate completions for'
            cand -h 'Print help'
            cand --help 'Print help'
        }
    ]
    $completions[$command]
}
